--
-- CruiseControlLevels
--
-- # Author:  Rival
-- # date: 21.12.21
-- # converted to FS25 13.11.24

CruiseControlLevels = {
	initSpecialization = function ()
		local schemaSavegame = Vehicle.xmlSchemaSavegame

		schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_CruiseControlLevels.cruiseControlLevels#currentLevel", "Current cruise control level")
		schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_CruiseControlLevels.cruiseControlLevels#speed1", "Cruise control speed level 1")
		schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_CruiseControlLevels.cruiseControlLevels#speed2", "Cruise control speed level 2")
		schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_CruiseControlLevels.cruiseControlLevels#speed3", "Cruise control speed level 3")
	end
}

function CruiseControlLevels.prerequisitesPresent(specializations)
    return true
end

function CruiseControlLevels.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", CruiseControlLevels)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", CruiseControlLevels)
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", CruiseControlLevels)
	SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", CruiseControlLevels)
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", CruiseControlLevels)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", CruiseControlLevels)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", CruiseControlLevels)
end

function CruiseControlLevels:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_ccl
		spec.actionEvents = {}
        self:clearActionEventsTable(spec.actionEvents)

        if self:getIsActiveForInput(true, true) then
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_CC_LEVEL, self, CruiseControlLevels.toggleCruiseControlLevel, false, true, false, true)
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_CC_LEVEL_BACK, self, CruiseControlLevels.toggleCruiseControlLevel, false, true, false, true)
        end
    end
end

function CruiseControlLevels:onLoad(savegame)
	self.spec_ccl = {}
	self.spec_ccl.speeds = {10, math.min(20,self:getCruiseControlMaxSpeed()), self:getCruiseControlMaxSpeed()}
	self.spec_ccl.currentLevel = 3
end

function CruiseControlLevels:onPostLoad(savegame)
	if savegame ~= nil then
		local speed1 = savegame.xmlFile:getValue(savegame.key .. ".FS25_CruiseControlLevels.cruiseControlLevels#speed1")
		local speed2 = savegame.xmlFile:getValue(savegame.key .. ".FS25_CruiseControlLevels.cruiseControlLevels#speed2")
		local speed3 = savegame.xmlFile:getValue(savegame.key .. ".FS25_CruiseControlLevels.cruiseControlLevels#speed3")
		local curLevel = savegame.xmlFile:getValue(savegame.key .. ".FS25_CruiseControlLevels.cruiseControlLevels#currentLevel")
		if speed1 ~= nil then
			self.spec_ccl.speeds[1] = speed1
		end
		if speed2 ~= nil then
			self.spec_ccl.speeds[2] = speed2
		end
		if speed3 ~= nil then
			self.spec_ccl.speeds[3] = speed3
		end
		if curLevel ~= nil then
			self.spec_ccl.currentLevel = curLevel
		end
		self:setCruiseControlMaxSpeed(self.spec_ccl.speeds[self.spec_ccl.currentLevel])
	end
end

---Called on client side on join
function CruiseControlLevels:onReadStream(streamId, connection)
    if connection:getIsServer() then
        self.spec_ccl.currentLevel = streamReadUIntN(streamId, 2)
        self.spec_ccl.speeds[1] = streamReadUIntN(streamId, 8)
        self.spec_ccl.speeds[2] = streamReadUIntN(streamId, 8)
        self.spec_ccl.speeds[3] = streamReadUIntN(streamId, 8)
    end
end

---Called on server side on join
function CruiseControlLevels:onWriteStream(streamId, connection)
    if not connection:getIsServer() then
        streamWriteUIntN(streamId, self.spec_ccl.currentLevel, 2)
        streamWriteUIntN(streamId, self.spec_ccl.speeds[1], 8)
        streamWriteUIntN(streamId, self.spec_ccl.speeds[2], 8)
        streamWriteUIntN(streamId, self.spec_ccl.speeds[3], 8)
    end
end

function CruiseControlLevels:setCruiseControlMaxSpeedListener(speed)
	if self.spec_ccl ~= nil then
		self.spec_ccl.speeds[self.spec_ccl.currentLevel] = speed
	end
end
Drivable.setCruiseControlMaxSpeed = Utils.appendedFunction(Drivable.setCruiseControlMaxSpeed, CruiseControlLevels.setCruiseControlMaxSpeedListener)

function CruiseControlLevels:saveToXMLFile(xmlFile, key, usedModNames)
    xmlFile:setValue(key .. "#speed1", math.ceil(self.spec_ccl.speeds[1]))
    xmlFile:setValue(key .. "#speed2", math.ceil(self.spec_ccl.speeds[2]))
    xmlFile:setValue(key .. "#speed3", math.ceil(self.spec_ccl.speeds[3]))
    xmlFile:setValue(key .. "#currentLevel", self.spec_ccl.currentLevel)
end

function CruiseControlLevels.toggleCruiseControlLevel(self, actionName, inputValue, callbackState, isAnalog)
	if self:getDrivingDirection() >= 0 then -- only works when not reversing
		if actionName == "TOGGLE_CC_LEVEL" then
			self.spec_ccl.currentLevel = self.spec_ccl.currentLevel + 1
			if self.spec_ccl.currentLevel > 3 then
				self.spec_ccl.currentLevel = 1
			end
		elseif actionName == "TOGGLE_CC_LEVEL_BACK" then
			self.spec_ccl.currentLevel = self.spec_ccl.currentLevel - 1
			if self.spec_ccl.currentLevel < 1 then
				self.spec_ccl.currentLevel = 3
			end
		end
		
		if g_server ~= nil then
			g_server:broadcastEvent(SetCruiseControlLevelEvent.new(self, self.spec_ccl.currentLevel), nil, nil, self)
		else
			g_client:getServerConnection():sendEvent(SetCruiseControlLevelEvent.new(self, self.spec_ccl.currentLevel))
		end
		
		self:setCruiseControlMaxSpeed(self.spec_ccl.speeds[self.spec_ccl.currentLevel])
		if self.spec_drivable.cruiseControl.speed ~= self.spec_drivable.cruiseControl.speedSent then
			if g_server ~= nil then
				g_server:broadcastEvent(SetCruiseControlSpeedEvent.new(self, self.spec_drivable.cruiseControl.speed, self.spec_drivable.cruiseControl.speedReverse), nil, nil, self)
			else
				g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent.new(self, self.spec_drivable.cruiseControl.speed, self.spec_drivable.cruiseControl.speedReverse))
			end
			self.spec_drivable.cruiseControl.speedSent = self.spec_drivable.cruiseControl.speed
			self.spec_drivable.cruiseControl.speedReverseSent = self.spec_drivable.cruiseControl.speedReverse
		end
	end
end

function CruiseControlLevels:onDraw()
	if self.spec_enterable.isEntered and self:getDrivingDirection() >= 0 then
		local cruiseOverlay = g_currentMission.hud.speedMeter.cruiseControl
		local KeyPosX = cruiseOverlay.x + cruiseOverlay.width * 0.8
		local KeyPosY = cruiseOverlay.y + cruiseOverlay.height * 0.66
		local KeyTextSize = g_currentMission.hud.speedMeter.cruiseControlTextSize * 0.5

		setTextColor(cruiseOverlay.r, cruiseOverlay.g, cruiseOverlay.b, cruiseOverlay.a)
		setTextBold(true)
		setTextAlignment(RenderText.ALIGN_LEFT)
		renderText(KeyPosX, KeyPosY, KeyTextSize, tostring(self.spec_ccl.currentLevel))
		setTextColor(1,1,1,1)
		setTextBold(false)
	end
end

SetCruiseControlLevelEvent = {}
local SetCruiseControlLevelEvent_mt = Class(SetCruiseControlLevelEvent, Event)

EventIds.assignEventObjectId(SetCruiseControlLevelEvent, "SetCruiseControlLevelEvent", 4711)

function SetCruiseControlLevelEvent.emptyNew()
	local self = Event.new(SetCruiseControlLevelEvent_mt)

	return self
end

function SetCruiseControlLevelEvent.new(vehicle, curLevel)
	local self = SetCruiseControlLevelEvent.emptyNew()
	self.curLevel = curLevel
	self.vehicle = vehicle

	return self
end

function SetCruiseControlLevelEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.curLevel = streamReadUIntN(streamId, 2)

	self:run(connection)
end

function SetCruiseControlLevelEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteUIntN(streamId, self.curLevel, 2)
end

function SetCruiseControlLevelEvent:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
		self.vehicle.spec_ccl.currentLevel = self.curLevel
	end
end
