ExtendedTerraforming = {};

function ExtendedTerraformingUpdateCursorHeights(self, oldfunc, x, y, z, scale)
    
    local function TryBlock(self, oldfunc, x, y, z, scale)
        local ray = self.ray
        local cursorShouldBeVisible = false

        if ray.x == nil then
            self.currentHitId = nil
        else
            if self.rayCollisionMask == nil then return; end--v1.1
    
            local id, x, y, z = RaycastUtil.raycastClosest(ray.x, ray.y, ray.z, ray.dx, ray.dy, ray.dz, GuiTopDownCursor.RAYCAST_DISTANCE, self.rayCollisionMask)
            self.currentHitZ = z
            self.currentHitY = y
            self.currentHitX = x
            self.currentHitId = id
    
            if id ~= nil then
    
                if self.rootNode == nil then return; end--v1.1
    
                if ExtendedTerraforming.TriggeredAxies == nil then
                    if self.currentHitId == g_currentMission.terrainRootNode then
                        setWorldTranslation(self.rootNode, x, y, z)
                    end
                else
                    if not ExtendedTerraforming.TriggeredAxies then
                        setWorldTranslation(self.rootNode, ExtendedTerraforming.StartX, y, z)
                    else
                        setWorldTranslation(self.rootNode, x, y, ExtendedTerraforming.StartZ)
                    end
                end
    
                cursorShouldBeVisible = not self.hitTerrainOnly or g_currentMission.terrainRootNode == id
    
                if self.shapeNode == nil then return; end--v1.1
                if self.shapeScale == nil then return; end--v1.1
    
                if x == nil then return; end--v1.1
                if y == nil then return; end--v1.1
                if z == nil then return; end--v1.1

                if cursorShouldBeVisible and getVisibility(self.shapeNode) then
                    self:updateCursorHeights(x, y, z, self.shapeScale)
                end
            end
        end
    
        self:setVisible(cursorShouldBeVisible)
    end
    
    pcall(TryBlock, self, oldfunc, x, y, z, scale)
end

function ExtendedTerraformingGetHitTerrainPosition(self)
    if ExtendedTerraforming.TriggeredAxies == nil then
        if self.currentHitId == g_currentMission.terrainRootNode then
            return self.currentHitX, self.currentHitY, self.currentHitZ;
        end
    else
        if not ExtendedTerraforming.TriggeredAxies then
            return ExtendedTerraforming.StartX, self.currentHitY, self.currentHitZ;
        else
            return self.currentHitX, self.currentHitY, ExtendedTerraforming.StartZ;
        end
    end
end

function ExtendedTerraformingGetPosition(self)
    if ExtendedTerraforming.TriggeredAxies == nil then
        return self.currentHitX, self.currentHitY, self.currentHitZ
    else
        if not ExtendedTerraforming.TriggeredAxies then
            return ExtendedTerraforming.StartX, self.currentHitY, self.currentHitZ;
        else
            return self.currentHitX, self.currentHitY, ExtendedTerraforming.StartZ;
        end
    end
end

function ExtendedTerraformingRegisterMenuActionEvents(self)
    valid, eventId = g_inputBinding:registerActionEvent(InputAction.LockAxis, "LockAxis", ExtendedTerraformingActivatedButton, false, true, true, true);

    ExtendedTerraforming.InputEvent = eventId;
    ExtendedTerraforming.ConstructionScreen = self;

    table.insert(self.menuEvents, eventId);

    g_inputBinding:setActionEventTextVisibility(ExtendedTerraforming.InputEvent, false);

end

function ExtendedTerraformingEntry()
    ExtendedTerraforming.StartX = ExtendedTerraforming.Active.cursor.currentHitX;
    ExtendedTerraforming.StartZ = ExtendedTerraforming.Active.cursor.currentHitZ;
end

function ExtendedTerraformingInAction()
    if ExtendedTerraforming.TriggeredAxies == nil and ExtendedTerraforming.StartX ~= nil and ExtendedTerraforming.StartZ ~= nil then
        local DistanceX = math.abs(ExtendedTerraforming.StartX - ExtendedTerraforming.Active.cursor.currentHitX)
        local DistanceZ = math.abs(ExtendedTerraforming.StartZ - ExtendedTerraforming.Active.cursor.currentHitZ)

        if DistanceX > 0.25 then ExtendedTerraforming.TriggeredAxies = true; return; end 
        if DistanceZ > 0.25 then ExtendedTerraforming.TriggeredAxies = false; return; end 
    end
end

function ExtendedTerraformingStopped()
    ExtendedTerraforming.TriggeredAxies = nil;
    ExtendedTerraforming.StartX = nil;
    ExtendedTerraforming.StartZ = nil;
end

function ExtendedTerraformingUpdate(self,dt)

    g_inputBinding:setActionEventTextVisibility(ExtendedTerraforming.InputEvent, true);

    if ExtendedTerraforming.Active ~= nil and ExtendedTerraforming.ActiveFrames ~= nil then
        if ExtendedTerraforming.ActiveFrames == 0 then
            ExtendedTerraforming.ActiveFrames = nil;
            ExtendedTerraformingStopped();
        else 
            ExtendedTerraforming.ActiveFrames = ExtendedTerraforming.ActiveFrames - 1;
            ExtendedTerraformingInAction();
        end
    end
end

function ExtendedTerraformingActivatedButton()
    if ExtendedTerraforming.Active ~= nil then
        if ExtendedTerraforming.ActiveFrames == nil then 
            ExtendedTerraformingEntry();
        end

        ExtendedTerraforming.ActiveFrames = 3;
    end
end

function ExtendedTerraformingActivate(self)
    ExtendedTerraforming.Active = self;
    g_inputBinding:setActionEventTextVisibility(ExtendedTerraforming.InputEvent, true);

end

function ExtendedTerraformingDactivate(self)
    ExtendedTerraforming.Active = nil;
    if ExtendedTerraforming.ActiveFrames ~= nil then ExtendedTerraformingStopped(); ExtendedTerraforming.ActiveFrames = nil; end
    g_inputBinding:setActionEventTextVisibility(ExtendedTerraforming.InputEvent, false);
end


GuiTopDownCursor.updateRaycast = Utils.overwrittenFunction(GuiTopDownCursor.updateRaycast, ExtendedTerraformingUpdateCursorHeights);
GuiTopDownCursor.getPosition = Utils.overwrittenFunction(GuiTopDownCursor.getPosition, ExtendedTerraformingGetPosition);
GuiTopDownCursor.getHitTerrainPosition = Utils.overwrittenFunction(GuiTopDownCursor.getHitTerrainPosition, ExtendedTerraformingGetHitTerrainPosition);

ConstructionScreen.registerMenuActionEvents = Utils.appendedFunction(ConstructionScreen.registerMenuActionEvents, ExtendedTerraformingRegisterMenuActionEvents);

ConstructionBrushPaint.activate = Utils.prependedFunction(ConstructionBrushPaint.activate, ExtendedTerraformingActivate);
ConstructionBrushPaint.deactivate = Utils.prependedFunction(ConstructionBrushPaint.deactivate, ExtendedTerraformingDactivate);
ConstructionBrushPaint.update = Utils.prependedFunction(ConstructionBrushPaint.update, ExtendedTerraformingUpdate);


