local modDir = g_currentModDirectory.. "scripte_vmdisplay/groupsRegister/";
local modName = g_currentModName;

local specFile = Utils.getFilename("vmControl.lua", modDir);

function registerSpecialization(typeManager)

	if g_specializationManager:getSpecializationByName("vmControl") == nil then
		g_specializationManager:addSpecialization("vmControl", "vmControl", specFile, nil);
		print("Mod:  register VehicleManager(TypId) by HappyLooser");
	end;
	
    if typeManager.typeName == "vehicle" then
        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
            if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations)
			and SpecializationUtil.hasSpecialization(Motorized, typeEntry.specializations)
			and SpecializationUtil.hasSpecialization(Enterable, typeEntry.specializations) then
                g_vehicleTypeManager:addSpecialization(typeName, modName..".vmControl")
            end
        end
    end
end
TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, registerSpecialization);

vmControlMPEvent = {};
local vmControlMPEvent_mt = Class(vmControlMPEvent, Event);

InitEventClass(vmControlMPEvent, "vmControlMPEvent");

function vmControlMPEvent.emptyNew()
    local self = Event.new(vmControlMPEvent_mt);
    --self.className="vmControlMPEvent";
    return self;
end;

function vmControlMPEvent.new(object)
    local self = vmControlMPEvent.emptyNew()
    self.object = object;
    return self;
end;

function vmControlMPEvent:readStream(streamId, connection)	
    self.object = NetworkUtil.readNodeObject(streamId);	
	
	--[[print("vmControlMPEvent:readStream(streamId, connection)")
	for k,v in pairs(self.object) do 
		print(tostring(k).." : "..tostring(v));
	end;]]
	local typId = streamReadString(streamId);
	self.object.vmControl.typId = tonumber(typId);
	vmControl:setTypId(tonumber(typId));
	vmControl:setNodeByTypId(tonumber(typId), self.object.rootNode);	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(vmControlMPEvent.new(self.object), nil, connection, self.object);
	end;

end;

function vmControlMPEvent:writeStream(streamId, connection)
	--[[print("vmControlMPEvent:readStream(streamId, connection)")
	for k,v in pairs(self.object) do 
		print(tostring(k).." : "..tostring(v));
	end;]]
    NetworkUtil.writeNodeObject(streamId, self.object);	
	local typId = self.object.vmControl.typId;
	streamWriteString(streamId, tostring(typId));	
end;

function vmControlMPEvent.updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(vmControlMPEvent.new(runSelf), nil, nil, runSelf);
	else
		g_client:getServerConnection():sendEvent(vmControlMPEvent.new(runSelf));
	end;

end;

