vmGroups = {};
vmGroups.values = {profile={["vm_Group_Profil"]={active=true, displayName="vm_Group_Profil", isVorlage=false}}, controlledVehicles={typId={},node={}}, markedVehicles={}, groups={}, onLoad={}, ghostGroupsVehicles=0, xmlLoaded=false, mapName="", isModMap=false, hasVorlage=false};
source(g_currentModDirectory.. "scripte_vmdisplay/groupsRegister/vmGroupsXml.lua");

function vmGroups:setGetMapData(get)
	local map = g_currentMission.missionInfo.map;
	if get ~= nil and get then return map.title, map.isModMap;end;
	vmGroups.values.mapName = map.title or "";
	vmGroups.values.isModMap = map.isModMap or false;	
end;

function vmGroups:getBoundsProfile()
	local bounds = 0;
	for profil, _ in pairs(vmGroups.values.profile) do
		if profil ~= nil then bounds = bounds+1;end;
	end;
	return bounds;
end;

function vmGroups:getProfile()
	local profile = {};
	for profil, value in pairs(vmGroups.values.profile) do				
		if value.active or not value.newFile then
			profile[#profile+1] = {active=value.active,name=profil,newFile=value.newFile,displayName=value.displayName,isVorlage=value.isVorlage or false};
		end;
	end;
	function comp(w1,w2)			
		return w1.name < w2.name;
	end;		
	table.sort(profile, comp);
	return profile;
end;

function vmGroups:hasProfilGroups()
	return vmGroups.values.groups[1] ~= nil;
end;

function vmGroups:getActiveProfil(small)
	if not VehicleManager_Display:getHostOrSp() then
		local savegameTypId = 0;
		if g_currentMission.hlUtilsMp ~= nil then savegameTypId = g_currentMission.hlUtilsMp.savegameTypId;end;
		if small ~= nil and small then return vmGroups.values.mapName;else
		return tostring(savegameTypId).. "_ID_".. vmGroups.values.mapName;end;
	end;
	return "vm_Group_Profil";	
end;

function vmGroups:setActiveProfil(profilName)
	for profil, value in pairs(vmGroups.values.profile) do
		if profil == profilName then vmGroups.values.profile[profil].active = true;else vmGroups.values.profile[profil].active = false;end;		
	end;
	--vmGroupsXml:saveConfig();
end;

function vmGroups:setVehicleAtGroup(vehicleNode, typId, group, uGroup, xmlLoaded)	
	if vehicleNode ~= nil and typId ~= nil and group ~= nil then
		group = vmGroups.values.groups[group]
		if group ~= nil and uGroup == nil then
			if group.typId[typId] == nil then
				group.typId[typId] = {node=vehicleNode, storeName=VehicleManager_DisplaySetGet:getStoreItemName(vehicleNode)};
				local vehicle = g_currentMission.nodeToObject[vehicleNode];
				local isVehicleSave = true;
				if vehicle ~= nil then 
					--group.typId[typId].notSave = false;
					isVehicleSave = VehicleManager_DisplaySetGet:isSaved(vehicle); --vehicle.currentSavegameId ~= nil;
					if g_client ~= nil and g_server == nil then 
						isVehicleSave = true; --unknown is save MP
						--g_currentMission.gameStatsTime = g_currentMission.time + g_currentMission.gameStatsInterval
					end;
				end;
				
				local duration = 3;
				local infoTxt = "";
				if not isVehicleSave then duration = 10;infoTxt = "\n".. g_i18n:getText("groups_insertVehicleNotSavegame") ;end;
				if xmlLoaded == nil then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("groups_insertVehicle").. infoTxt, maxLine=0, txtBold=true, duration=duration} );end;
				if not group.viewOpen then group.viewOpen = true;end;
			else
				group.typId[typId] = nil;
				if xmlLoaded == nil then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("groups_deleteVehicle"), txtBold=true, duration=3, warning=true} );end;
				if vmGroups:getTypIdLength(group.typId) == 0 then group.viewOpen = false;group.viewTyp = 1;end;
			end;
			--print("###typId")
			--print(DebugUtil.printTableRecursively(group, "groupTables ", 0, 5))
			vmGroupsXml:saveProfil();
		
		elseif group ~= nil and uGroup ~= nil then
			uGroup = group.uGroups[uGroup];
			if uGroup.typId[typId] == nil then
				uGroup.typId[typId] = {node=vehicleNode, storeName=VehicleManager_DisplaySetGet:getStoreItemName(vehicleNode)};
				local vehicle = g_currentMission.nodeToObject[vehicleNode];
				local isVehicleSave = true;
				if vehicle ~= nil then 
					--group.typId[typId].notSave = false;
					isVehicleSave = vehicle.currentSavegameId ~= nil;
					if g_client ~= nil and g_server == nil then 
						isVehicleSave = true; --unknown is save MP
						--g_currentMission.gameStatsTime = g_currentMission.time + g_currentMission.gameStatsInterval
					end;
				end;
				local duration = 3;
				local infoTxt = "";
				if not isVehicleSave then duration = 10;infoTxt = "\n".. g_i18n:getText("groups_insertVehicleNotSavegame") ;end;
				if xmlLoaded == nil then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("groups_insertVehicle").. infoTxt, maxLine=0, txtBold=true, duration=duration} );end;
				if not uGroup.viewOpen then uGroup.viewOpen = true;end;
			else
				uGroup.typId[typId] = nil;
				if xmlLoaded == nil then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("groups_deleteVehicle"), txtBold=true, duration=3, warning=true} );end;
				if vmGroups:getTypIdLength(uGroup.typId) == 0 then uGroup.viewOpen = false;uGroup.viewTyp = 1;end;
			end;
			vmGroupsXml:saveProfil();
		end;
	end;
end;

function vmGroups:delVehicleAtGroup(vehicleNode, typId, group, uGroup, xmlLoaded)	
	if vehicleNode ~= nil and typId ~= nil and group ~= nil then
		group = vmGroups.values.groups[group]
		if group ~= nil then
			if uGroup == nil then 
				group.typId[typId] = nil;
				local typIdLength = vmGroups:getTypIdLength(group.typId);
				if typIdLength == 0 then group.viewTyp = 1;end;
				if typIdLength == 0 and (group.uGroups == nil or #group.uGroups == 0) then group.viewOpen = false;end;
			end;
			--uGroups--
			if uGroup ~= nil then
				uGroup = group.uGroups[uGroup];
				if uGroup ~= nil then
					uGroup.typId[typId] = nil;
					if vmGroups:getTypIdLength(uGroup.typId) == 0 then uGroup.viewOpen = false;uGroup.viewTyp = 1;end;	
				end;
			end;
			--uGroups--
			if xmlLoaded == nil then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("groups_deleteVehicle"), txtBold=true, duration=3, warning=true} );end;
			vmGroupsXml:saveProfil();
		end;		
	end;
end;

function vmGroups:delVehicleAtGroups(typId)	
	if typId ~= nil then
		for g=1, #vmGroups.values.groups do
			local group = vmGroups.values.groups[g]
			if group ~= nil then
				group.typId[typId] = nil;
				local typIdLength = vmGroups:getTypIdLength(group.typId);
				if typIdLength == 0 then group.viewTyp = 1;end;
				if typIdLength == 0 and (group.uGroups == nil or #group.uGroups == 0) then group.viewOpen = false;end;
				--uGroups--
				for ug=1, #group.uGroups do
					local uGroup =group.uGroups[ug];
					if uGroup ~= nil then
						uGroup.typId[typId] = nil;
						if vmGroups:getTypIdLength(uGroup.typId) == 0 then uGroup.viewOpen = false;uGroup.viewTyp = 1;end;
					end;
				end;
				--uGroups--				
			end;
		end;
		vmGroups.values.markedVehicles[typId] = nil;
		vmGroupsXml:saveProfil();
	end;
end;

function vmGroups:getTypIdLength(t)
	if t == nil then return 0;end;
	local length = 0;
    for _, __ in pairs(t) do
        length = length+1;
    end;
    return length;
end;

function vmGroups:getTypIdLengthAllUGroups(t)
	if t == nil then return 0;end;
	local length = 0;
	if vmGroups.values.groups[t] == nil or vmGroups.values.groups[t].uGroups == nil or #vmGroups.values.groups[t].uGroups == 0 then return 0;end;
	for ug=1, #vmGroups.values.groups[t].uGroups do
		length = length+vmGroups:getTypIdLength(vmGroups.values.groups[t].uGroups[ug].typId);
	end;
	return length;
end;

function vmGroups:isUgroupViewTyp(group)
	if vmGroups.values.groups[group] ~= nil and vmGroups.values.groups[group].uGroups ~= nil and #vmGroups.values.groups[group].uGroups > 0 then
		for ug=1, #vmGroups.values.groups[group].uGroups do
			if vmGroups.values.groups[group].uGroups[ug].viewTyp > 1 then return true;end;
		end;
	end;
	return false;
end;

function vmGroups:setAllGroupViewTypOff(group)
	if vmGroups.values.groups[group] ~= nil and vmGroups.values.groups[group].uGroups ~= nil and #vmGroups.values.groups[group].uGroups > 0 then
		for ug=1, #vmGroups.values.groups[group].uGroups do
			vmGroups.values.groups[group].uGroups[ug].viewTyp = 1;
		end;
	end;
	if vmGroups.values.groups[group] ~= nil then vmGroups.values.groups[group].viewTyp = 1;end;
end;

function vmGroups:renameGroups(groupName, group, uGroup)
	if ls25Convert then
		local text = g_i18n:getText("button_changeName");
		local defaultText = tostring(groupName);
		local confirmText = g_i18n:getText("button_change");	
		g_gui:showTextInputDialog({		
			text = text,
			defaultText = defaultText,
			callback = function (result, yes)
				if yes then
					if result:len() < 2 or result:len() > 30 then
						result = nil;
						g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 30", txtBold=true, duration=3, warning=true} );					
					else
						vmGroups:renameGroup(tostring(result), group, uGroup);														
					end
				end
			end,
			dialogPrompt = g_i18n:getText("ui_enterName").. "\n(min length 2/max length 30)",
			imePrompt = g_i18n:getText("ui_enterName"),
			confirmText = confirmText,
			maxCharacters = 40,
			disableFilter = true
			--activateInputText = activateInputText,
			--args = args
		})
	else
		local okayText = g_i18n:getText("button_refresh");
		local backText = g_i18n:getText("button_cancel");
		local dialogPrompt = "Group-".. g_i18n:getText("button_changeName");
		local callback = function (result, yes)
			if yes then
				if result:len() < 2 or result:len() > 30 then
					result = nil;
					g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 30", txtBold=true, duration=3, warning=true} );					
				else
					vmGroups:renameGroup(tostring(result), group, uGroup);														
				end;
			end;
		end;
		local dialog = g_gui:showDialog("TextInputDialog");		
		--dialog.target:setTitle(title); --not active
		dialog.target:setText(dialogPrompt);
		--dialog.target:setMaxCharacter(30); --default is 30
		dialog.target:setDialogType(DialogElement.TYPE_QUESTION);
		dialog.target:setButtonTexts(okayText, backText);
		dialog.target:setCallback(callback, nil, groupName);
	end;
end;

function vmGroups:renameGroup(groupName, group, uGroup)
	local oldGroupName = vmGroups.values.groups[group].name;
	if uGroup ~= nil then 
		oldGroupName =  vmGroups.values.groups[group].uGroups[uGroup].name;
		vmGroups.values.groups[group].uGroups[uGroup].name = groupName;
	else
		vmGroups.values.groups[group].name = groupName;
	end;
	g_currentMission.hlUtils.addTextDisplay( {txt=string.format(g_i18n:getText("groups_renamed"), oldGroupName, groupName), txtBold=true, duration=3} );
	vmGroupsXml:saveProfil();
end;

function vmGroups:deleteGroups(groupName, group, uGroup)
	if vmGroups.values.groups[group] ~= nil then
		if ls25Convert then
			g_gui:showYesNoDialog({				 
				text = string.format(g_i18n:getText("groups_deleteYesNo"), groupName);
				title = "VehicleManager Group Info"; 				
				callback = function (yes)
					if yes then
						vmGroups:deleteGroup(groupName, group, uGroup)	
					end
				end,				
			});
		else
			local okayText = g_i18n:getText("button_delete");
			local backText = g_i18n:getText("button_cancel");
			local text = string.format(g_i18n:getText("groups_deleteYesNo"), groupName);
			local title = "VehicleManager Profil Info"; 
			local callback = function(yes)
				if yes then
					vmGroups:deleteGroup(groupName, group, uGroup)
				end;
			end;
			local dialog = g_gui:showDialog("YesNoDialog");
			dialog.target:setTitle(title);
			dialog.target:setText(text);	
			dialog.target:setButtonTexts(okayText, backText);
			dialog.target:setCallback(callback);
		end;
	end;
end;

function vmGroups:deleteGroup(groupName, group, uGroup)
	if uGroup ~= nil then
		table.remove(vmGroups.values.groups[group].uGroups, uGroup);
	else
		table.remove(vmGroups.values.groups, group);
	end;
	g_currentMission.hlUtils.addTextDisplay( {txt=string.format(g_i18n:getText("groups_deleted"), groupName), txtBold=true, duration=3} );
	vmGroupsXml:saveProfil();
end;

function vmGroups:generateNewGroups(box, group)
	if ls25Convert then
		local text = g_i18n:getText("ui_farmNew");	
		local confirmText = "Generate New Groups:";	
		if group ~= nil then confirmText = "Generate New Group at Group:";end;	
		g_gui:showTextInputDialog({
			text = text,		
			callback = function (result, yes)
				if yes then
					if result:len() < 2 or result:len() > 30 then
						result = nil;
						g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 30", txtBold=true, duration=3, warning=true} );					
					else
						vmGroups:insertNewGroups(box, tostring(result), true, group);										
					end
				end
			end,
			dialogPrompt = g_i18n:getText("ui_enterName").. "\n(min length 2/max length 30)",
			imePrompt = g_i18n:getText("ui_enterName"),
			confirmText = confirmText,
			maxCharacters = 30,
			disableFilter = true
			--activateInputText = activateInputText,
			--args = args
		})
	else
		local okayText = g_i18n:getText("button_apply");
		local backText = g_i18n:getText("button_quit");
		local dialogPrompt = "Generate New Group:";
		if group ~= nil then dialogPrompt = "Generate New Group at Group:";end;	
		dialogPrompt = dialogPrompt.. "\n".. g_i18n:getText("ui_enterName").. "\n(min length 2/max length 30)";
		local callback = function (result, yes)
			if yes then
				if result:len() < 2 or result:len() > 30 then
					result = nil;
					g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 30", txtBold=true, duration=3, warning=true} );					
				else
					vmGroups:insertNewGroups(box, tostring(result), true, group);										
				end;
			end;	
		end;
		local dialog = g_gui:showDialog("TextInputDialog");
		--dialog.target:setTitle(title); --not active
		dialog.target:setText(dialogPrompt);
		--dialog.target:setMaxCharacter(30); --default is 30
		dialog.target:setDialogType(DialogElement.TYPE_QUESTION);
		dialog.target:setButtonTexts(okayText, backText);
		dialog.target:setCallback(callback);		
	end;
end;

function vmGroups:insertNewGroups(box, groupName, guiDialog, group)	
	if groupName == nil or type(groupName) ~= "string" then
		g_currentMission.hlUtils.addTextDisplay( {txt="Not generate Groups ! Name is corrupt !", txtBold=true, duration=3} );
		return;
	end;
	--local groupsXmlName = string.gsub(groupName, " ", "");
	if group ~= nil then
		local newGroup = {name=groupName, viewOpen=false, viewTyp=1, maxViewTyp=2, typId={}, marker={text="",color={}}, ghostVehicles=false};
		table.insert(vmGroups.values.groups[group].uGroups, 1, newGroup); --position 1
		if not vmGroups.values.groups[group].viewOpen then vmGroups.values.groups[group].viewOpen = true;end;
	else
		local newGroup = {name=groupName, viewOpen=false, viewTyp=1, maxViewTyp=2, typId={}, uGroups={}, marker={text="", color={}}, ghostVehicles=false};
		table.insert(vmGroups.values.groups, 1, newGroup); --position 1
	end;	
	box:setUpdateState(true);	
	if guiDialog ~= nil and guiDialog then g_currentMission.hlUtils.addTextDisplay( {txt=string.format(g_i18n:getText("groups_generated"), groupName), txtBold=true, duration=3} );end;
	vmGroupsXml:saveProfil();
end;

function vmGroups:newGroupsPosition(mouseClick, groupName, group, uGroup)
	if uGroup == nil then
		if #vmGroups.values.groups < 2 then return;end;
		local oldPos = group;
		local newPos = 0;
		local cloneGroup = vmGroups.values.groups[group];
		if mouseClick == "down" then
			newPos = oldPos+1;		
			if vmGroups.values.groups[newPos] == nil then newPos = 1;end;	
		elseif mouseClick == "up" then
			newPos = oldPos-1;
			if newPos <= 0 then newPos = #vmGroups.values.groups;end;		
		end;
		table.remove(vmGroups.values.groups, oldPos);
		table.insert(vmGroups.values.groups, newPos, cloneGroup);
	elseif group ~= nil and uGroup ~= nil then
		if #vmGroups.values.groups[group].uGroups < 2 then return;end;
		local oldPos = uGroup;
		local newPos = 0;
		local cloneGroup = vmGroups.values.groups[group].uGroups[uGroup];
		if mouseClick == "down" then
			newPos = oldPos+1;		
			if vmGroups.values.groups[group].uGroups[newPos] == nil then newPos = 1;end;	
		elseif mouseClick == "up" then
			newPos = oldPos-1;
			if newPos <= 0 then newPos = #vmGroups.values.groups[group].uGroups;end;		
		end;
		table.remove(vmGroups.values.groups[group].uGroups, oldPos);
		table.insert(vmGroups.values.groups[group].uGroups, newPos, cloneGroup);
	end;	
	vmGroupsXml:saveProfil();
end;

function vmGroups:setUgroupNextGroup(mouseClick, groupName, group, uGroup)
	if #vmGroups.values.groups > 1 and group ~= nil and uGroup ~= nil then		
		local setNew = false;
		local nextGroup = 0;
		local newPos = nil;
		local cloneGroup = vmGroups.values.groups[group].uGroups[uGroup];
		if mouseClick == "up" then
			if uGroup ~= 1 then return;end;
			if vmGroups.values.groups[group-1] ~= nil then 
				nextGroup = group-1;				
			else 
				nextGroup = #vmGroups.values.groups;				
			end;
			setNew = true;
		elseif mouseClick == "down" then
			if uGroup ~= #vmGroups.values.groups[group].uGroups then return;end;
			if vmGroups.values.groups[group+1] ~= nil then 
				nextGroup = group+1;				
			else 
				nextGroup = 1;				
			end;
			if #vmGroups.values.groups[nextGroup].uGroups > 0 then nextPos = 1;end;
			setNew = true;
		end;
		if setNew then
			table.remove(vmGroups.values.groups[group].uGroups, uGroup);
			if #vmGroups.values.groups[group] == 0 then vmGroups.values.groups[group].viewOpen = false;end;
			vmGroups.values.groups[nextGroup].viewOpen = true;
			if newPos ~= nil then table.insert(vmGroups.values.groups[nextGroup].uGroups, newPos, cloneGroup);else table.insert(vmGroups.values.groups[nextGroup].uGroups, cloneGroup);end;			
			vmGroupsXml:saveProfil();
		end;
	end;
end;

function vmGroups:closeAllOpenGroups()
	for g=1, #vmGroups.values.groups do
		vmGroups.values.groups[g].viewOpen = false;
		if #vmGroups.values.groups[g].uGroups > 0 then
			for ug=1, #vmGroups.values.groups[g].uGroups do
				vmGroups.values.groups[g].uGroups[ug].viewOpen = false;
			end;
		end;
	end;
	vmGroupsXml:saveProfil();
end;

function vmGroups:isGroupExists(groupName)	
	if groupName ~= nil and #vmGroups.values.groups > 0 then
		for g=1, #vmGroups.values.groups do
			if vmGroups.values.groups[g].name == groupName then return g;end;
		end;
	end;
	return 0;
end;

function vmGroups:isGroupOpen()
	for g=1, #vmGroups.values.groups do
		if vmGroups.values.groups[g].viewOpen then return true;end;
	end;
	return false;
end;

function vmGroups:getOpenBounds()
	local bounds = 0;
	for g=1, #vmGroups.values.groups do
		if vmGroups.values.groups[g].viewOpen then 
			if vmGroups.values.groups[g].typId ~= nil then bounds = bounds + vmGroups:getTypIdLength(vmGroups.values.groups[g].typId);end;
			bounds = bounds + #vmGroups.values.groups[g].uGroups;
			if #vmGroups.values.groups[g].uGroups > 0 then
				for ug=1, #vmGroups.values.groups[g].uGroups do
					if vmGroups.values.groups[g].uGroups[ug].viewOpen and vmGroups.values.groups[g].uGroups[ug].typId ~= nil then
						bounds = bounds + vmGroups:getTypIdLength(vmGroups.values.groups[g].uGroups[ug].typId);
					end;
				end;
			end;
		end;		
	end;
	return bounds;
end;

function vmGroups:getControlledVehicleGroup(group, uGroup)
	if g_localPlayer == nil or not g_localPlayer:getIsInVehicle() then return false;end;	
	local vehicle = g_localPlayer:getCurrentVehicle();
	if vehicle == nil or vehicle.vmControl == nil then return false;end;
	local group = vmGroups.values.groups[group];
	if uGroup ~= nil then group = group.uGroups[uGroup];end;
	if group.viewOpen then return false;end;	
	if group.typId[vehicle.vmControl.typId] ~= nil then return true;end;
	if uGroup == nil and group.uGroups ~= nil and #group.uGroups > 0 then
		for ug=1, #group.uGroups do			
			if group.uGroups[ug].typId[vehicle.vmControl.typId] ~= nil then return true;end;			
		end;
	end;
	return false;
end;


function vmGroups:generateDriverNames()
	if ls25Convert then
		local vehicle = g_currentMission.controlledVehicle;
		if vehicle == nil or vehicle.vmControl == nil or vehicle.vmControl.typId == nil or vehicle.vmControl.typId == 0 then return;end;
		local text = g_i18n:getText("ui_farmNew");
		local defaultText = vehicle.vmControl.driverName or "";
		local confirmText = g_i18n:getText("button_ok");
		local backText = g_i18n:getText("button_close").. "/".. g_i18n:getText("button_reset");
		g_gui:showTextInputDialog({		
			text = text,
			defaultText = defaultText,
			callback = function (result, yes)
				if yes then
					if result:len() < 2 or result:len() > 40 then
						result = nil;
						g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 40", txtBold=true, duration=3, warning=true} );					
					else
						vmGroups:generateDriverName(tostring(result));														
					end
				else
					vmGroups:generateDriverName();	
				end
			end,
			dialogPrompt = g_i18n:getText("ui_enterName").. "\n(min length 2/max length 40)",
			imePrompt = g_i18n:getText("ui_enterName"),
			confirmText = confirmText,
			backText = backText;
			maxCharacters = 40,
			disableFilter = true
			--activateInputText = activateInputText,
			--args = args
		})
	else
		if g_localPlayer == nil or g_localPlayer.getCurrentVehicle == nil or g_localPlayer:getCurrentVehicle() == nil then return;end;
		local vehicle = g_localPlayer:getCurrentVehicle();
		if vehicle == nil or vehicle.vmControl == nil or vehicle.vmControl.typId == nil or vehicle.vmControl.typId == 0 then return;end;	
		local okayText = g_i18n:getText("button_ok");
		local backText = g_i18n:getText("button_close").. "/".. g_i18n:getText("button_reset");
		local dialogPrompt = g_i18n:getText("ui_enterName").. "(".. g_i18n:getText("passengerSeat_driver").. ")\n(min length 2/max length 30)";		
		local imeText = vehicle.vmControl.driverName or "";
		local callback = function (result, yes)
			if yes then
				if result:len() < 2 or result:len() > 30 then
					result = nil;
					g_currentMission.hlUtils.addTextDisplay( {txt="Characters min 2/max 30", txtBold=true, duration=3, warning=true} );					
				else
					vmGroups:generateDriverName(tostring(result));										
				end;
			else
				vmGroups:generateDriverName();
			end;	
		end;
		local dialog = g_gui:showDialog("TextInputDialog");
		--dialog.target:setTitle("VehicleManager Drivername");
		dialog.target:setText(dialogPrompt);
		--dialog.target.maxCharacter = 30; --default is 30
		dialog.target:setDialogType(DialogElement.TYPE_QUESTION);
		dialog.target:setButtonTexts(okayText, backText);
		dialog.target:setCallback(callback, nil, imeText);			
	end;
end;

function vmGroups:generateDriverName(driverName)
	if g_localPlayer == nil or not g_localPlayer:getIsInVehicle() then return;end;	
	local vehicle = g_localPlayer:getCurrentVehicle();	
	if vehicle == nil or vehicle.vmControl == nil then return;end;
	if driverName == nil then vehicle.vmControl.driverName = nil;else vehicle.vmControl.driverName = tostring(driverName);end;	
	if driverName == nil then vmControl:setDriverNameByTypId(vehicle.vmControl.typId);else vmControl:setDriverNameByTypId(vehicle.vmControl.typId, driverName);end;
	vmGroupsXml:saveProfil();
end;

function vmGroups:isViewVehicleGroup(args) --VehicleInspector query
	if args == nil then return false,false;end;
	local vehicle = args.vehicle;
	local isGroupTotal = 0;
	local isGroup = false;
	local viewGroup = false;
	local isUgroup = false;
	local viewUgroup = false;
	if vehicle ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.typId ~= nil then
		local uGroupFound = false;
		for g=1, #vmGroups.values.groups do			
			if (isGroup and viewGroup) or (isUgroup and viewUgroup) then break;end;
			
			isGroup = vmGroups.values.groups[g].typId ~= nil and vmGroups.values.groups[g].typId[vehicle.vmControl.typId] ~= nil;
			if isGroup then
				isGroupTotal = isGroupTotal+1;
				viewGroup = vmGroups.values.groups[g].viewTyp == 2;
			end;			
			
			if (isGroup and viewGroup) or (isGroupTotal > 0 and viewGroup) then break;end;
						
			if #vmGroups.values.groups[g].uGroups > 0 then
				for ug=1, #vmGroups.values.groups[g].uGroups do
					isUgroup = vmGroups.values.groups[g].uGroups[ug].typId ~= nil and vmGroups.values.groups[g].uGroups[ug].typId[vehicle.vmControl.typId] ~= nil;
					if isUgroup then 
						isGroupTotal = isGroupTotal+1;
						viewUgroup = vmGroups.values.groups[g].uGroups[ug].viewTyp == 2;
					end;
					
					if (isUgroup and viewUgroup) or (isGroupTotal > 0 and viewUgroup) then break;end;
					
				end;
			end;
		end;
		if not isGroup and isUgroup then isGroup = true;end;
		if not isGroup and isGroupTotal > 0 then isGroup = true;end;
		if not viewGroup and viewUgroup then viewGroup = true;end;		
	end;
	return isGroup, viewGroup;
end;

function vmGroups:setMarkedVehicleByTypId(args)
	if args == nil then return;end;	
	if args.typId ~= nil and args.status ~= nil then		
		if vmGroups.values.markedVehicles[args.typId] ~= nil and not args.status then
			vmGroups.values.markedVehicles[args.typId] = nil;
			vmGroupsXml:saveProfil();
		elseif vmGroups.values.markedVehicles[args.typId] == nil and args.status then
			local node = vmControl:getNodeByTypId(args.typId);			
			vmGroups.values.markedVehicles[args.typId] = {node=node, storeName=VehicleManager_DisplaySetGet:getStoreItemName(node)};
			vmGroupsXml:saveProfil();
		end;
	end;
	return;
end;

function vmGroups:setMarkedVehicleByNode(args)
	if args == nil then return;end;
	if args.node ~= nil and args.status ~= nil then
		local typId = vmControl:getTypIdByNode(args.node);
		if typId ~= 0 then
			if vmGroups.values.markedVehicles[typId] ~= nil and not args.status then
				vmGroups.values.markedVehicles[typId] = nil;
				vmGroupsXml:saveProfil();
			elseif vmGroups.values.markedVehicles[typId] == nil and args.status then
				vmGroups.values.markedVehicles[typId] = {node=args.node, storeName=VehicleManager_DisplaySetGet:getStoreItemName(args.node)};
				vmGroupsXml:saveProfil();
			end;
		end;
	end;
	return;
end;

function vmGroups:generateGroupByMission(args) --missions leasing vehicles, (disabled)
	if args == nil then return false;end;
	if args.groupName ~= nil then
		local group = vmGroups:isGroupExists(args.groupName);
		if group == 0 then
			local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box"); --search Box
			if box ~= nil then
				vmGroups:insertNewGroups(box, args.groupName, false);
				vmGroups.values.groups[1].isMission = args.missionId or 0;
				if args.vehicles ~= nil and #args.vehicles > 0 then
					for v=1, #args.vehicles do
						if args.vehicles[v].node ~= nil and args.vehicles[v].typId ~= nil then
							vmGroups:setVehicleAtGroup(args.vehicles[v].node, args.vehicles[v].typId, 1, nil, false);
						end;
					end;
				end;
				return true;
			end;
		end;
	end;
	return false;
end;

function vmGroups:copyPasteProfil(profilName, isVorlage)	
	if ls25Convert then
		g_gui:showYesNoDialog({				 
			text = string.format(g_i18n:getText("profile_copyPaste"), g_i18n:getText("profile_vorlage"));
			title = "VehicleManager Profil Info"; 				
			callback = function(yes)
				if yes then
					vmGroupsXml:copyPasteProfil(profilName, isVorlage);	
				end
			end,				
		});
	else
		local text = string.format(g_i18n:getText("profile_copyPaste"), g_i18n:getText("profile_vorlage"));
		local title = "VehicleManager Profil Info"; 
		local callback = function(yes)
			if yes then
				vmGroupsXml:copyPasteProfil(profilName, isVorlage);	
			end;
		end;
		local dialog = g_gui:showDialog("YesNoDialog");
		dialog.target:setTitle(title);
		dialog.target:setText(text);	
		dialog.target:setCallback(callback);
	end;
end;

function vmGroups:setGlobalFunctions()
	g_currentMission.hlUtils.globalFunction["FS25_VehicleManagerDisplay"] = {
		getMetadata = function()return VehicleManager_Display.metadata;end;
		isViewVehicleGroup = function(args)return vmGroups:isViewVehicleGroup(args);end;
		setMarkedVehicleByTypId = function(args)return vmGroups:setMarkedVehicleByTypId(args);end;
		setMarkedVehicleByNode = function(args)return vmGroups:setMarkedVehicleByNode(args);end;
		generateGroupByMission = function(args)return vmGroups:generateGroupByMission(args);end;
	};	
end;