--
-- Tip On Field During Missions
--
-- Author: [AGDM]Haubi
-- Description: allows to dump goods on active mission fields.
-- Name: Tip On Field During Missions
--

MissionTipOnField = {}

function MissionTipOnField:findMissionToFarmlandId(farmlandId)
	for _, mission in ipairs(g_missionManager.missions) do
		if mission.field ~= nil then
			if mission.field.farmland ~= nil then
				if mission.field.farmland.id == farmlandId then
					return mission
				end
			end
		end
	end
	return nil
end

function MissionTipOnField:getCanDischargeToLand(superFunc, dischargeNode)
	
	local ret = superFunc(self, dischargeNode)
	
	if not ret then 
		if dischargeNode == nil then
			return false
		end

		local info = dischargeNode.info
		local sx, _, sz = localToWorld(info.node, -info.width, 0, info.zOffset)
		local ex, _, ez = localToWorld(info.node, info.width, 0, info.zOffset)
		local x, z = 0, 0
		local activeFarm = self:getActiveFarm()

		local mission = g_missionManager:getMissionAtWorldPosition(sx, sz)
		local farmland = g_farmlandManager:getFarmlandAtWorldPosition(sx, sz)
		if mission == nil then
			if farmland ~= nil then
				mission = MissionTipOnField:findMissionToFarmlandId(farmland.id)
			end
		end
		
		if mission ~= nil and mission.farmId == activeFarm and (mission.status == MissionStatus.RUNNING or mission.status == MissionStatus.FINISHED) and (mission.type.name == "harvestMission" or mission.type.name == "stonePickMission") then
			return true
		end
	end
	
	return ret
end

function MissionTipOnField:getCanShovelAtPosition(superFunc, shovelNode)
	local ret = superFunc(self, shovelNode)
	
	if not ret then 
		if shovelNode == nil then
			return false
		end

		local sx, _, sz = localToWorld(shovelNode.node, -shovelNode.width * 0.5, 0, 0)
		local activeFarm = self:getActiveFarm()
		local ex, _, ez = localToWorld(shovelNode.node, shovelNode.width * 0.5, 0, 0)
		local isStartOwned = g_currentMission.accessHandler:canFarmAccessLand(activeFarm, sx, sz)

		
		local mission = g_missionManager:getMissionAtWorldPosition(sx, sz)
		local farmland = g_farmlandManager:getFarmlandAtWorldPosition(sx, sz)
		if mission == nil then
			if farmland ~= nil then
				mission = MissionTipOnField:findMissionToFarmlandId(farmland.id)
			end
		end
		if mission ~= nil and mission.farmId == activeFarm and (mission.status == MissionStatus.RUNNING or mission.status == MissionStatus.FINISHED) and (mission.type.name == "harvestMission" or mission.type.name == "stonePickMission") then
			return true
		end
	end

	return ret
end

local function init()

Dischargeable.getCanDischargeToLand = Utils.overwrittenFunction(Dischargeable.getCanDischargeToLand, MissionTipOnField.getCanDischargeToLand)
Shovel.getCanShovelAtPosition = Utils.overwrittenFunction(Shovel.getCanShovelAtPosition, MissionTipOnField.getCanShovelAtPosition)
end

init()
